from log import logger
from typing import Dict, List, Tuple, Set
import requests
from bs4 import BeautifulSoup

# data sources
from dbAPI import dbAPI
from data.sito_poli_dataset2 import data as dataPoli

from customTypes import *


db = dbAPI()
log = logger(True)


def wrDelete_InsegnamentoInOrientamento(ID_INC:int):
    '''wrapper per togliere le schifezze che ho nel db'''
    db.delete_InsegnamentoInOrientamento(str(ID_INC),"Cybersecurity","INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)","Obbligatorio_a_scelta","Z")

def extractInsegnamentiParallelizzabili():
    '''Estrae tutti gli insegnamenti parallelizzabili. 
    Eg. gli insegnamenti appartenenti ad alfabetiche diverse o le versioni italiano/inglese dello stesso.
    QUESTI SONO I DATI PER TUTTI I CDL
    \n
    NB: va lanciato per aggiornare la lista nei seguenti casi:
        - modifica di data.sito_poli_dataset2
        - modifica della lista dei codIns riferiti ad un ID_INC nel db
    '''
    insUgualiIngInfo = [ # per codIns -> ad es le alfabetiche di APA hanno tutte lo stesso codIns
        ["02GOLOV","02LSEOV"],
        ["01SQJOV", "01SQMOV"],
        ["01OTWOV", "02KPNOV"],
        ["05BIDOV", "04GSPOV"],
        ["01UDFOV", "01TXYOV"],
        ["02GRSOV", "01NYHOV"],
        ["01TYMOV", "01UDUOV"],
        ["01PDXOV", "01PECOV"],
        ["02MIVOQ", "01NNIOQ"],
        ["01NVIOQ", "01NNKOQ"],
        ["01NNLOQ", "05BVCOQ"],
        ["01NVDOQ", "01NNNOQ"],
        ["02MZGOD", "07ATIOD"], # Elettronica applicata
        ["16ACFOD", "04KWQOD"], # Analisi matematica I
        ["06KWROD", "15AHMOD"], # Chimica
        ["07JCJOD", "14BHDOD"], # Informatica
        ["17AXOOD", "04KXVOD"], # Fisica I
        ["01RKCOD", "03KXTOD"], # Linear algebra and geometry
        ["12AGAOA", "02KTMOA"], # 	Calcolatori elettronici
        ["14AFQOA", "01RKWOA"], # Basi di dati
        ["04JEZOA", "05CJCOA"], # Sistemi operativi
        ["06QXWOA", "05QXVOA"], # Sistemi elettronici, tecnologie e misure
        ["08KSIOA", "15CDUOA"], # Reti di calcolatori
        ["02OGGOA", "02MOOOA"], # 	Teoria ed elaborazione dei segnali
        ["06LSLOA", "18AKSOA"], # Controlli automatici
        ["03MZGOA", "08ATIOA"], # 	Elettronica applicata
        ["04JEYOA", "09CBIOA"], # Programmazione a oggetti
        ["11APMNX", "06LTHNX"], # Dispositivi elettronici
        ["12EIUNX", "03OIGNX"], # Circuiti elettronici
        ["02MZGNX", "04ATINX"], # 	Elettronica applicata
        ["05AGPNX", "02MTKNX"], # Campi elettromagnetici
        ["03LTJNX", "01MOFNX"], # Misure
        ["04OIHNX", "08ATNNX"], # Elettronica dei sistemi digitali
        ["02OGGPC", "02MOOPC"], # Teoria ed elaborazione dei segnali
        ["08KSIPC", "15CDUPC"], # Reti di calcolatori
        # ["01RKYOV", "01UDSOV"], # chiedere a qualcuno. Sembrano 2 corsi diversi, boh (da qui in avanti lo sono tutti)  
        # ["01QWIBG", "01QWHBG"],
        # ["03QWNBG", "04SOHBG"],
        # ["02GQCOQ", "01UBAOQ"],
        # ["01OBCOQ", "02OUXOQ"],
        # ["03JSGOQ", "01UAXOQ"],
        # ["01POIOQ", "01NVTOQ"],
        # ["01NRWOQ", "02LPNOQ"],
        # ["02LONQW", "01RXOQW"],
        # ["01PCZQW", "04LSLQW"],
        # ["01RKYQW", "02MPLQW"],
        # ["01PDXQW", "01TVOQW"],
        # ["01PEDQW", "01RKXQW"]
    ]

    insUgualiIngInfo2:List[List[str]] = list()

    for i in range(len(dataPoli)):
        if dataPoli[i][0] == "table_content":
            for j in range(len(dataPoli[i][1])):
                if dataPoli[i][1][j][0] == "oppure":
                    cod1:str = dataPoli[i][1][j-1][1]
                    cod2:str = dataPoli[i][1][j+1][1]
                    if cod1 == cod2:
                        continue
                    if cod1 in ['Challenge', 'Crediti liberi'] or cod2 in ['Challenge', 'Crediti liberi']:
                        continue
                    if len(cod1) != 7 or len(cod2) != 7:
                        continue
                    giaPresente:bool = False
                    
                    for k in range(len(insUgualiIngInfo2)):
                        if cod1 in insUgualiIngInfo2[k] and cod2 not in insUgualiIngInfo2[k]:
                            insUgualiIngInfo2[k].append(cod2)
                            print("tripla")
                            giaPresente = True
                        if cod2 in insUgualiIngInfo2[k] and cod1 not in insUgualiIngInfo2[k]:
                            insUgualiIngInfo2[k].append(cod1)
                            print("tripla")
                            giaPresente = True
                        if cod1 in insUgualiIngInfo2[k] and cod2 in insUgualiIngInfo2[k]:
                            giaPresente = True
                    if not giaPresente:
                        insUgualiIngInfo2.append([cod1, cod2])
    

    # # check validity of autogen
    # for i in range(len(insUgualiIngInfo)):
    #     err = False
    #     for j in range(len(insUgualiIngInfo2)):
    #         if insUgualiIngInfo[i][0] in insUgualiIngInfo2[j] and insUgualiIngInfo[i][1] in insUgualiIngInfo2[j]:
    #             err = False
    #             break
    #         else:
    #             err = True
    #     if err:
    #         print("tupla mancante in insUgualiIngInfo2: " + str(insUgualiIngInfo[i]))
    # for i in range(len(insUgualiIngInfo2)):
    #     err = False
    #     for j in range(len(insUgualiIngInfo)):
    #         if insUgualiIngInfo2[i][0] in insUgualiIngInfo[j] and insUgualiIngInfo2[i][1] in insUgualiIngInfo[j]:
    #             err = False
    #             break
    #         else:
    #             err = True
    #     if err:
    #         print("tupla mancante in insUgualiIngInfo: " + str(insUgualiIngInfo2[i]))

    # diz:Dict[str,List[Tuple[str,str]]] = dict()

    insegnamenti = db.get_Insegnamenti_withCodIns()

    diz_ID_INC_codIns:Dict[str,List[str]] = dict() # diz per {ID_INC:[codIns,codIns,], ID_INC... }
    diz_ID_INC_titoli:Dict[str,List[str]] = dict() # {ID_INC:[titolo,titolo,], ID_INC... }
    diz_codIns_ID_INC:Dict[str,List[str]] = dict() # {codIns: [ID_INC, ID_INC], codIns... }
    
    for row in insegnamenti:
        ID_INC = str(row[0])
        titolo = str(row[4])
        codIns = str(row[8])
        
        # per ogni ID_INC ho la lista di codIns
        if ID_INC not in diz_ID_INC_codIns.keys():
            diz_ID_INC_codIns[ID_INC] = list()
            diz_ID_INC_titoli[ID_INC] = list()
        diz_ID_INC_codIns[ID_INC].append(codIns)
        diz_ID_INC_titoli[ID_INC].append(titolo)
        
        # per ogni codIns ho la lista di ID_INC
        if codIns not in diz_codIns_ID_INC.keys():
            diz_codIns_ID_INC[codIns] = list()
        diz_codIns_ID_INC[codIns].append(ID_INC)

            
    # può capitare che diversi ID_INC si riferiscano allo stesso codIns -> ho un solo codIns ma diversi ID_INC
    # ogni codIns in oppure dal dataSet del sito del poli viene trasformato nella lista di ID_INC corrispondente
    listInsegnamentiParallelizzabili_list:List[List[str]] = list()
    for groupCodIns_sitoPoli in insUgualiIngInfo2:
        # la nuova lista di insegnamenti parallelizzabili
        listInsegnamentiParallelizzabili_list.append(list())
        index = len(listInsegnamentiParallelizzabili_list)-1
        
        print(groupCodIns_sitoPoli)

        for codIns in groupCodIns_sitoPoli:
            # per ogni codIns certo tutti i corrispondenti ID_INC
            for ID_INC, groupCodIns_db in diz_ID_INC_codIns.items():
                # se il codIns dal dataSet poli corrisponde a quelli dell'ID_INC corrente -> aggiungo ID_INC a quelli del grp parallelizabile corrente
                if codIns in groupCodIns_db:
                    if ID_INC not in listInsegnamentiParallelizzabili_list[index]:
                        listInsegnamentiParallelizzabili_list[index].append(ID_INC)
        
        # print(listInsegnamentiParallelizzabili_list[index])                    
    
    # qui ho ottenuto la lista di ID_INC per tutti gli Insegnamenti che compaiono in "oppure" sul sito del Poli
    # devo ancora tenere conto degli Insegnamente che hanno un unico codIns ma diversi ID_INC (eg: le alfabetiche)
    for codIns,listID_INC in diz_codIns_ID_INC.items():
        if len(listID_INC)>1:
            listInsegnamentiParallelizzabili_list.append(listID_INC)
    
    # tolgo entry vuote
    listInsegnamentiParallelizzabili_noEmptyLists = [l for l in listInsegnamentiParallelizzabili_list if len(l) > 0]
    
    # print(listInsegnamentiParallelizzabili_list)
    print(listInsegnamentiParallelizzabili_noEmptyLists)

# extractInsegnamentiParallelizzabili()

    
    
def extractInsegnamnenti_Poli():
    '''Estrae dal sito del Poli tutti i dati dai piani studi. Inserimento manuale degli Orientamenti'''
    listOrientamenti:List[str] = [
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=9",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=3",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=1",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=10",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=21",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=17",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=18",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=24",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_a_acc=2022&p_sdu=37&p_cds=320",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=30",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=20",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=13",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=22",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=18",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=23",
        "https://didattica.polito.it/pls/portal30/sviluppo.offerta_formativa_2019.vis?p_coorte=2022&p_sdu=37&p_cds=55"
    ]
    listTitlesCdl:List[str] = list()
    listAllData = list()
    prevData = 0

    for url in listOrientamenti:
        resp = requests.get(url)
        soup = BeautifulSoup(resp.content, "html.parser")
        listTablesToSkip = [0,1]
        curTable:int = -1
        listRes = list()
        listTitles = list(map(lambda t:(str(t).split(">")[1])[:-6],  list(soup.find_all("span", {"style":"font-weight: bold;", "data-toggle":"collapse"}))))
        listTitlesCdl.append(soup.find("h1").get_text())
        
        # interactive part
        print(listTitlesCdl[len(listTitlesCdl)-1])
        print(url)
        listAllData.append(["cdl", listTitlesCdl[len(listTitlesCdl)-1], url])
        
        for tableHtml in soup.find_all("table"):
            curTable +=1
            if curTable in listTablesToSkip:
                continue
            
            index_table = len(listRes)
            listRes.append(list())  
            
            rows = tableHtml.children
            for row in rows:
                soupRow = BeautifulSoup(row.get_text(), "html.parser")
                listEntry = list(soupRow.get_text().split('\n'))
                if len(listEntry) == 2 and listEntry[0] == '' and listEntry[1] == '':
                    continue
                # "oppure"
                if len(listEntry) == 5:
                    listRes[index_table].append(["oppure"])
                # header
                elif listEntry[1] == "Periodo":
                    listRes[index_table].append(["periodo", "codIns", "cfu"])
                # a scelta
                elif "a scelta" in listEntry[9]:
                    listRes[index_table].append([listEntry[1], listEntry[9], listEntry[13]])
                elif "liberi" in listEntry[9]:
                    listRes[index_table].append([listEntry[1], listEntry[9], listEntry[13]])
                elif listEntry[10] == "Tesi":
                    listRes[index_table].append([listEntry[1], "Tesi", "0"])
                elif listEntry[10] == "Challenge":
                    listRes[index_table].append([listEntry[1], "Challenge", "0"])                      
                else:
                    listRes[index_table].append([listEntry[1], listEntry[3], listEntry[11]])
            
            print(listTitles[index_table])
            print(listRes[index_table])
            
            strOrientamento = input("Nome orientamento? ->")
            # se sta iniziando la prima tabella di un orientamento
            if strOrientamento != '':
                listAllData.append(["orientamento", strOrientamento])

            listAllData.append(["table_title", listTitles[index_table]])
            listAllData.append(["table_content", listRes[index_table]])
        
        # per ogni tabella ho il titolo della tabella
        assert(len(listTitles) == len(listRes))
        
        for i in range(prevData, len(listAllData)):
            print(listAllData[i])
        prevData = len(listAllData)
  
    
    
# per la completa gestione di dataPoli
    
def helper_codInsToID_INC(listCodIns:List[Tuple[str,TipoInsegnamento]], listName:List[Tuple[str,TipoInsegnamento]]) -> List[Tuple[str,TipoInsegnamento]]:
    '''Mappa ogni codIns nel o nei rispettivo/i ID_INC. Se il codIns non è presente nel db non viene ritornato\n 
    args:
        listCodIns: [(codIns, TipoInsegnamento), ..], lista parallela contenente i nomi degli Insegnamenti
    Return:
        [(ID_INC, TipoInsegnamento), ..]'''
    insegnamenti = db.get_Insegnamenti_withCodIns()
    listRes:List[Tuple[str,TipoInsegnamento]] = list()
        
    for index_codIns in range(len(listCodIns)):   
        codIns = listCodIns[index_codIns]
        nomeIns = listName[index_codIns]
         
        foundAtLeastOne:bool = False
        # ricerca nel db
        for row in insegnamenti:
            ID_INC = str(row[0])
            codIns_db = str(row[8])
            if codIns[0] == codIns_db:
                listRes.append((ID_INC, codIns[1]))
                foundAtLeastOne = True
                
        if not foundAtLeastOne:
            log.info_logUtils("WARN dbToolbox.helper_codInsToID_INC(): no ID_INC found for " + nomeIns[0] + " - " + codIns[0])
    return listRes   
    
def dataPoli_findLimitsCdl(cdl:str) -> Tuple[int,int]:
    '''Trova gli id limite del cdl specificato.
    
    Return:
        [a,b) (int,int): limiti del cdl'''
    a = -1
    b = -1
    for i in range(len(dataPoli)):
        if dataPoli[i][0] == 'cdl' and dataPoli[i][1] == cdl:
            a = i
        elif dataPoli[i][0] == 'cdl' and a != -1:
            b = i
            return a,b
    # se sono qui -> ultimo cdl
    b = len(dataPoli)
    return a,b

def dataPoli_findOrientamenti(a:int,b:int) -> List[Tuple[int,str]]:
    '''Cerca gli id di tutti gli orientamenti nell'intervallo specificato [a,b).
    
    Return:
        [(index_orientamento, nome_orientamento), ..]'''
    res = list()
    for i in range(a,b):
        if dataPoli[i][0] == "orientamento":
            res.append((i,dataPoli[i][1]))
    return res
            
def dataPoli_findTables(a:int, b:int, primary:bool = False) -> List[Tuple[int,str]]:
    '''Cerca gli id di tutte le tabelle nell'intervallo specificato [a,b).
    
    Return:
        [(index_heading_table, table_name), ..]'''
    res = list()
    for i in range(a,b):
        if dataPoli[i][0] == "table_title" and not primary:
            res.append((i,dataPoli[i][1]))
        elif dataPoli[i][0] == "table_title" and primary and "scelta" not in dataPoli[i][1] and "liberi" not in dataPoli[i][1] and "Tesi" not in dataPoli[i][1] and "Free" not in dataPoli[i][1] and "Tabella" not in dataPoli[i][1] and "Challenge" not in dataPoli[i][1] and "Thesis" not in dataPoli[i][1] and "Final project work" not in dataPoli[i][1] and "Choice" not in dataPoli[i][1]:
            res.append((i,dataPoli[i][1]))
    # print(res)
    return res



          
def extractTipologiaInsegnamentiInOrientamento(cdlName_sitoPoliDataset:str, cdlName_db:str):
    '''Per ogni Orientamento (se presende nel db) identifica i diversi livelli di importanza dei singoli Insegnamenti.\n
    Workflow:
        - importa i dati da sito_poli_dataset2.py
        - crea le liste di Insegnamenti dello stesso Orientamento e dello stesso anno, scarta gli Insegnamenti del 2° periodo didattico
        - codIns -> ID_INC (anche più di uno, eg: alfabetiche)
        - cancella per il determinato cdl e Orientamento le entry presenti nel db e mette queste più precise (opzionale, fatto perchè prima
        salvavo dati non precisi) -> upgrades di Insegnamento_in_Orientamento
    \n
    Nota:
        - va fatta manualmente per ogni cdl
        - fixare dataPoli in modo che abbia riferimenti a tabelle solo a singolo livello
        - ? 
    \n
    PS: ricorda di controllare se lo script è configurato per inserire gli Insegnamenti della Triennale o della Magistrale'''
    print()
    print('*'*60)
    print(cdlName_sitoPoliDataset)
    
    a,b = dataPoli_findLimitsCdl(cdlName_sitoPoliDataset)
    listOrientamenti_ids:List[Tuple[int,str]] = dataPoli_findOrientamenti(a,b)
    for index_listOrientamenti_ids in range(len(listOrientamenti_ids)):
        # per ogni Orientamento
        # print(listOrientamenti_ids[index_listOrientamenti_ids][1])
        
        if index_listOrientamenti_ids+1 == len(listOrientamenti_ids):
            # l'ultimo orientamento finisce al cambio di cdl
            listTables_ids:List[Tuple[int,str]] = dataPoli_findTables(listOrientamenti_ids[index_listOrientamenti_ids][0],
                                                                      b)
            listTablesPrimary_ids:List[Tuple[int,str]] = dataPoli_findTables(listOrientamenti_ids[index_listOrientamenti_ids][0],
                                                                           b, True)
        else:
            listTables_ids:List[Tuple[int,str]] = dataPoli_findTables(listOrientamenti_ids[index_listOrientamenti_ids][0],
                                                                  listOrientamenti_ids[index_listOrientamenti_ids+1][0])
            listTablesPrimary_ids:List[Tuple[int,str]] = dataPoli_findTables(listOrientamenti_ids[index_listOrientamenti_ids][0],
                                                                  listOrientamenti_ids[index_listOrientamenti_ids+1][0], True)
        # se la tabella contiene ref ad altre tabelle -> devo esplorare le altre tabelle (ricorsivamente)
        # gli Insegnamenti già presenti in una tabella di default saranno di tipo Obbligatorio (gestione degli oppure 
        # fatta altrove)
        
        # il risultato è la lista di Insegnamenti dell'Orientamento
        listRes:List[List[Tuple[str,TipoInsegnamento]]] = list() # questa è solo per debugging -> contiene i nomi degli Insegnamenti
        listRes_ID_INC:List[List[Tuple[str,TipoInsegnamento]]] = list() # parallela alla precedente
        
        # 1: inserisco gli Insegnamenti Obbligatori -> ogni lista conterrà gli Insegnamenti obbligatori
        # di un anno accademico (tolgo anche quelli del secondo perdiodo didattico)
        # per ogni Tabella di un anno accademico
        for index_listPrimaryTables in range(len(listTablesPrimary_ids)):
            listRes.append(list()) # la lista di Insegnamenti per quell'anno per quell'Orientamento
            listRes_ID_INC.append(list())
            # la lista è alla entry successiva a table_title
            for insegnamento_dataPoli in dataPoli[listTablesPrimary_ids[index_listPrimaryTables][0]+1][1]:
                # insegnamento_dataPoli è la singola entry del tipo:
                # ['table_content', [['periodo', 'codIns', 'cfu'], ...]
                if len(insegnamento_dataPoli) == 3 and len(insegnamento_dataPoli[1]) <= 7:
                    # è un Insegnamento
                    # filtro sul periodo didattico
                    if '1' in insegnamento_dataPoli[0]:
                        listRes[index_listPrimaryTables].append((insegnamento_dataPoli[2], TipoInsegnamento.Obbligatorio))
                        listRes_ID_INC[index_listPrimaryTables].append((insegnamento_dataPoli[1], TipoInsegnamento.Obbligatorio))
        
        # 2: devo aggiungere gli Insegnamenti di tipo diverso alle liste base
        for index_listPrimaryTables in range(len(listTablesPrimary_ids)):
            # per ogni primary table
            
            for insegnamento_dataPoli in dataPoli[listTablesPrimary_ids[index_listPrimaryTables][0]+1][1]:
                # per ogni Insegnamento, è da espandere ?
                
                if len(insegnamento_dataPoli) == 3 and len(insegnamento_dataPoli[1]) > 7:
                    # è il ref ad un'altra tabella
                    # HP: RIFERIMENTI SOLO DI PRIMO ORDINE -> FIXARE BENE DATASET
                   
                    tabellaDaCercare = insegnamento_dataPoli[1]
                    # cerco tra le tabelle dell'Orientamento
                    for index_listTables in range(len(listTables_ids)):
                        if tabellaDaCercare == listTables_ids[index_listTables][1]:
                            # tabella trovata -> aggiungo alla lista corrispondente nella tabella primary tutte le entry 
                            # con i corretti livelli di importanza
                            if "scelta" in tabellaDaCercare:
                                for insegnamentoExp in dataPoli[listTables_ids[index_listTables][0]+1][1]:
                                    # filtro pd
                                    if '1' in insegnamentoExp[0] or '2' in insegnamentoExp[0]:
                                        listRes[index_listPrimaryTables].append((insegnamentoExp[2], TipoInsegnamento.TabellaAScelta))
                                        listRes_ID_INC[index_listPrimaryTables].append((insegnamentoExp[1], TipoInsegnamento.TabellaAScelta))
                            elif "Free" in tabellaDaCercare or "liberi" in tabellaDaCercare:
                                for insegnamentoExp in dataPoli[listTables_ids[index_listTables][0]+1][1]:
                                    # filtro pd
                                    if '1' in insegnamentoExp[0] or '2' in insegnamentoExp[0]:
                                        listRes[index_listPrimaryTables].append((insegnamentoExp[2], TipoInsegnamento.CreditoLibero))
                                        listRes_ID_INC[index_listPrimaryTables].append((insegnamentoExp[1], TipoInsegnamento.CreditoLibero))
                            elif "Tabella" in tabellaDaCercare and not "scelta" in tabellaDaCercare:
                                for insegnamentoExp in dataPoli[listTables_ids[index_listTables][0]+1][1]:
                                    # filtro pd
                                    if '1' in insegnamentoExp[0] or '2' in insegnamentoExp[0]:
                                        listRes[index_listPrimaryTables].append((insegnamentoExp[2], TipoInsegnamento.ObbligatorioAScelta))
                                        listRes_ID_INC[index_listPrimaryTables].append((insegnamentoExp[1], TipoInsegnamento.ObbligatorioAScelta))
                            # una volta espanso il singolo ref posso passare a verificare se ne esistono altri
                            break
        
            # print(listRes[index_listPrimaryTables])
            # print()
        
        # passaggio da codIns a ID_INC per ogni tabella dell'Insegnamento
        listRes_ID_INC_v2:List[List[Tuple[str,TipoInsegnamento]]] = list()
        for index_table in range(len(listRes_ID_INC)):
            listRes_ID_INC_v2.append(helper_codInsToID_INC(listRes_ID_INC[index_table], listRes[index_table]))
            # print(listRes_ID_INC_v2[index_table])
        
        # print(listRes_ID_INC_v2)
        writeDb = 'y'
        while writeDb not in ['y','n']:
            writeDb = input("Update db ? [y/n]")
        if writeDb == 'y':
            orientamento:str = listOrientamenti_ids[index_listOrientamenti_ids][1]
            cdl:str = cdlName_db # il nome all'interno del db
            
            if "Magistrale" in cdlName_sitoPoliDataset:
                # db.delete_allInsegnamentiInOrientamento(orientamento, cdl, "Z")
                # aggiunta nuove entries
                for index_table in range(len(listRes_ID_INC_v2)):
                    if index_table == 0: # primo anno
                        db.update_InsegnamentiInOrientamento(orientamento, cdl, listRes_ID_INC_v2[index_table], "Z", "1-1")
                        # db.add_InsegnamentiInOrientamento(orientamento, cdl, "Z", "1-1", listRes_ID_INC_v2[index_table])
                    elif index_table == 1: # secondo anno
                        # db.add_InsegnamentiInOrientamento(orientamento, cdl, "Z", "2-1", listRes_ID_INC_v2[index_table])
                        db.update_InsegnamentiInOrientamento(orientamento, cdl, listRes_ID_INC_v2[index_table], "Z", "2-1")
            else:
                # db.delete_allInsegnamentiInOrientamento(orientamento, cdl, "1")
                # aggiunta nuove entries
                for index_table in range(len(listRes_ID_INC_v2)):
                    if index_table == 0: # primo anno
                        db.update_InsegnamentiInOrientamento(orientamento, cdl, listRes_ID_INC_v2[index_table], "1", "1-1")
                        # db.add_InsegnamentiInOrientamento(orientamento, cdl, "1", "1-1", listRes_ID_INC_v2[index_table])
                    elif index_table == 1: # secondo anno
                        db.update_InsegnamentiInOrientamento(orientamento, cdl, listRes_ID_INC_v2[index_table], "1", "2-1")
                        # db.add_InsegnamentiInOrientamento(orientamento, cdl, "1", "2-1", listRes_ID_INC_v2[index_table])
                    elif index_table == 2: # terzo anno
                        # db.add_InsegnamentiInOrientamento(orientamento, cdl , "1", "3-1", listRes_ID_INC_v2[index_table])
                        db.update_InsegnamentiInOrientamento(orientamento, cdl, listRes_ID_INC_v2[index_table], "1", "3-1")

def db_updateListInsegnamenitInOrientamento_forAllCdl():
    listCdl:List[Tuple[str,str]] = list()
    '''Lista di tutti i cdl magistrali, con i rispettivi nomi in sitoPoliDataset e nel db'''
    
    listCdl.append(("Corso  di Laurea Magistrale in Physics  of complex systems (fisica dei sistemi complessi) (Torino/Trieste/Parigi)", "PHYSICS OF COMPLEX SYSTEMS (FISICA DEI SISTEMI COMPLESSI)"))
    # Insegnamenti sconosciuti
    # Fluidodinamica - 07AYFPF
    # Modelli statistici - 02NMRPF
    # Modelli di sistemi fisiologici - 02LMUPF
    
    listCdl.append(("Corso  di Laurea Magistrale in Data  science and engineering (Torino)","DATA SCIENCE AND ENGINEERING"))
    # Insegnamenti sconosciuti
    # Modelli matematici per la Biomedicina - 01RMYSM
    
    listCdl.append(("Corso  di Laurea Magistrale in Communications  and computer networks engineering (ingegneria telematica e delle comunicazioni) (Torino)","COMMUNICATIONS AND COMPUTER NETWORKS ENGINEERING (INGEGNERIA TELEMATICA E DELLE COMUNICAZIONI)"))
    # Insegnamenti sconosciuti
    # Programmable electronic systems - 02NVPBG
    # Orientamenti sconosciuti -> non ho nessun Insegnamento da allocare per questo Orientamento in pratica
    # Orientamento "Eurecom"
    
    listCdl.append(("Corso  di Laurea Magistrale in Ict  for smart societies (ict per la societa' del futuro) (Torino)","ICT FOR SMART SOCIETIES (ICT PER LA SOCIETA' DEL FUTURO)"))
    # Insegnamenti sconosciuti
    # Communication and network systems - 02USKBH
    # Programmable electronic systems - 02NVPBG

    listCdl.append(("Corso  di Laurea Magistrale in Ingegneria  elettronica (electronic engineering) (Torino)","INGEGNERIA ELETTRONICA (ELECTRONIC ENGINEERING)"))
    # Insegnamenti sconosciuti
    # Wireless Integrated Circuits and Systems - 01VDROQ
    # Orientamenti sconosciuti
    # Orientamento "Eurecom"
    # Master of Science in Electrical Engineering and Computer Science (TOP-UIC)
    
    listCdl.append(("Corso  di Laurea Magistrale in Ingegneria  del cinema e dei mezzi di comunicazione (Torino)","INGEGNERIA DEL CINEMA E DEI MEZZI DI COMUNICAZIONE"))
    # Insegnamenti sconosciuti
    # Applicazioni digitali per l'arte - 01UGZPD
    # Sound & sonic interaction design - 01RSXPD
    # Tecniche di registrazione e postproduzione audio - 01SBLPD
    # Teoria e tecnica del segnale audio digitale - 01RSWPD
    # Vodafone IoT Academy - 02UOUPD
    # Processi musicali automatici e interattivi - 02RSVPD
    
    listCdl.append(("Corso  di Laurea Magistrale in Ingegneria  informatica (computer engineering) (Torino)","INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)"))
    # Insegnamenti sconosciuti
    # Optimization methods and algorithms - 01OUVOV
    # Bioinformatics - 01OVFOV
    # Robotica - 04CFIOV
    # per tutti gli orientamenenti non vengo parsati correttamente: ma tanto non li devo allcare io probably
        # Processi musicali automatici e interattivi - 02RSVPD
        # Sound & sonic interaction design - 01RSXPD
        # Teoria e tecnica del segnale audio digitale - 01RSWPD
    # Orientamenti mancanti:
    # Orientamento "Eurecom"
    # Master of Science in Electrical and Computer Engineering (TOP-UIC)
    
    listCdl.append(("Corso  di Laurea Magistrale in Nanotechnologies  for icts (nanotecnologie per le ict) (Torino/Grenoble/Losanna)","NANOTECHNOLOGIES FOR ICTs (NANOTECNOLOGIE PER LE ICT)"))
    # Insegnamenti sconosciuti
    # Analog circuits, VLSI and modelling - 01NPKPE
    # From micro to nanosystems: nanoelectronics and optoelectronics - 01NPLPE
    # Labs - 01NPMPE
    # Complementi di metodi matematici per la fisica - 01SZAPE
    # Complementi di struttura della materia - 02AJNPE
    # Maybe non sono nemmeno al Poli:
    # Algorithmic and Programming - 01DFOPE
    # Digital Image Processing and Analysis - 01DFNPE
    # Laser Physics - 01DFRPE
    # Optical Engineering - 01DFIPE
    # Physical and Fourier Optics - 01DFFPE
    # Scientific Computing with Matlab - 01DFQPE
    # Scientific Methodology and Project Management - 01DFPPE
    
    listCdl.append(("Corso  di Laurea Magistrale in Mechatronic  engineering (ingegneria meccatronica) (Torino)","MECHATRONIC ENGINEERING (INGEGNERIA MECCATRONICA)"))
    # Insegnamenti mancanti:
    # nessuno
    
    # Orientamenti triennale
    listCdl.append(("Corso  di Laurea in Ingegneria  fisica (Torino)","INGEGNERIA FISICA"))
    # Insegnamenti mancanti:
    # Science and technology studies - 01SUMOD
    
    listCdl.append(("Corso  di Laurea in Ingegneria  informatica (computer engineering) (Torino)","INGEGNERIA INFORMATICA (COMPUTER ENGINEERING)"))
    # Insegnamenti mancanti:
    # Signal analysis and processing - 02OGGLM
    # Science and technology studies - 01SUMLM
    
    listCdl.append(("Corso  di Laurea in Ingegneria  elettronica (Torino)","INGEGNERIA ELETTRONICA"))
    # Insegnamenti mancanti:
    # Science and technology studies - 01SUMNX
    
    listCdl.append(("Corso  di Laurea in Ingegneria  informatica (Torino)","INGEGNERIA INFORMATICA"))
    # Signal analysis and processing - 02OGGLM
    
    listCdl.append(("Corso  di Laurea in Ingegneria  del cinema e dei mezzi di comunicazione (Torino)","INGEGNERIA DEL CINEMA E DEI MEZZI DI COMUNICAZIONE"))
    # Industrie Creative Digitali - 01DSGPC
    # Signal analysis and processing - 02OGGLM
    # Science and technology studies - 01SUMPC
    
    listCdl.append(("Corso  di Laurea in Electronic  and communications engineering (ingegneria elettronica e delle comunicazioni) (Torino)","ELECTRONIC AND COMMUNICATIONS ENGINEERING (INGEGNERIA ELETTRONICA E DELLE COMUNICAZIONI)"))
    # Science and technology studies - 01SUMLP

    id:int = 14

    for index_cdl in range(len(listCdl)):
        # if id != index_cdl:
            # continue
        
        cdl = listCdl[index_cdl]
        log.info_logUtils("dbToolbox.db_updateListInsegnamenitInOrientamento_forAllCdl(): work on " + cdl[1])
        extractTipologiaInsegnamentiInOrientamento(cdl[0], cdl[1])
        log.info_logUtils("\n\n")
            
# db_updateListInsegnamenitInOrientamento_forAllCdl()
    
    
    
def extractAlfabetiche_ofOrientamento(orientamento, nomeCdl, tipoCdl, periodoDidattico, cmdUpdate:str = ''):
    # per ogni Orientamento (per ogni cdl), per ogni PeriodoDidattico, ho per ogni Insegnamento la lista di alfabetiche
    
    rows = db.get_Alfabetiche_ofOrientamento(orientamento, nomeCdl, tipoCdl, periodoDidattico)   
    # rows = db.get_Alfabetiche_WARNING() NON USARE: potrei avere degli Insegnamenti specifici ad un cdl (eg. Teoria dei segnali per ing cinema)
    diz_nAlfab:Dict[int,int] = dict() # per ogni candidato num di alfabetiche conto quante istanze ho
    for row in rows:
        nAlfab = int(row[0])
        if nAlfab > 1:
            if nAlfab not in diz_nAlfab.keys():
                diz_nAlfab[nAlfab] = 0
            diz_nAlfab[nAlfab] += 1
    if len(rows) < 1:
        return
    print(orientamento + "." + nomeCdl + "." + tipoCdl + ":")
    print(rows)
    
    # select il numero di alfabetiche da usare
    nAlfabetiche = 1
    resNOcc = 0
    for nAlf, nOcc in diz_nAlfab.items():
        if nOcc > resNOcc:
            nAlfabetiche = nAlf
            resNOcc = nOcc
    # per tutti gli Insegnamenti con nAlfabetiche devo estrarre i vari ID_INC
    for row in rows:
        nAlf = int(row[0]) 
        insTitolo = str(row[1])
        insCFU = str(row[2])
        if nAlf == nAlfabetiche:
            listID_INC = db.get_ID_INC_Insegnamento_ofOrientamento_WARNING(orientamento, nomeCdl, tipoCdl, periodoDidattico, insTitolo, insCFU)
            if len(listID_INC) <= 1:
                continue # è un credito libero/ a scelta che compare in più tabelle
            print(insTitolo)
            print(listID_INC)
            
            # ask for update db
            updateDb = cmdUpdate
            while updateDb not in ['y','n']:
                updateDb = input("update db? [y/n] -> ")
            if updateDb == 'y':
                indexAlfabetica = 1
                for ID_INC in listID_INC:
                    db.update_Alfabetica_ofInsegnamentoInOrientamento(ID_INC[0], orientamento, nomeCdl, tipoCdl, periodoDidattico, str(indexAlfabetica))
                    indexAlfabetica += 1
    print()
                    
def extractAlfabetiche():
    '''Estrae e setta nel db le alfabetiche per tutti gli Orientamenti'''
    db.reset_Alfabetica()
    listOrientamenti = db.get_Orientamenti()
    for rowOrient in listOrientamenti:
        if rowOrient[2] == "1":
            extractAlfabetiche_ofOrientamento(rowOrient[0], rowOrient[1], rowOrient[2], "2-1", 'y')
            extractAlfabetiche_ofOrientamento(rowOrient[0], rowOrient[1], rowOrient[2], "3-1", 'y')
        elif rowOrient[2] == "Z":
            extractAlfabetiche_ofOrientamento(rowOrient[0], rowOrient[1], rowOrient[2], "1-1", 'y')
            extractAlfabetiche_ofOrientamento(rowOrient[0], rowOrient[1], rowOrient[2], "2-1", 'y')
            
# extractAlfabetiche()



def cazzo():
    rowsOrientamenti = db.get_Orientamenti()
    for rowOrient in rowsOrientamenti:
        orientamento:str = rowOrient[0]
        nomeCdl:str = rowOrient[1]
        tipoCdl:str = rowOrient[2]
        if tipoCdl == 'Z': # solo le triennali
            continue
        if "Mondovì" in rowOrient[0]: # sono uguali agli Orientamenti normali, solo il primo anno (che non mi interessa) è a Mondovì
            continue
        if "Talenti" in rowOrient[0]:
            continue
        if "INTRAPRENDENTI" in rowOrient[0]:
            continue
        if "Primo anno erogato in italiano" == rowOrient[0]:
            continue
        if "Shanghai" in rowOrient[0]:
            continue
        if "Introductory year taught in English" == rowOrient[0]:
            continue
        if "Eurecom" in rowOrient[0]:
            continue
        
        print(orientamento + "." + nomeCdl)
        
        rowsInsegnamenti = db.get_Insegnamenti_withOrientamento(orientamento, nomeCdl, tipoCdl)
        for rowIns in rowsInsegnamenti:
            insID_INC = str(rowIns[0])
            insTitolo = rowIns[4]
            insCfu = rowIns[5]
            insTipo = rowIns[9]
            insAlfabetica = rowIns[11]
            if getTipoInsegnamentoFromStr(insTipo) not in [TipoInsegnamento.Obbligatorio, TipoInsegnamento.ObbligatorioAScelta]:
                continue
            print(insID_INC + " - " + insTitolo + " cfu: " + insCfu + " tipo: " + insTipo + " alfabetica: " + insAlfabetica)
        print()
        
# cazzo()